% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Operations.R
\name{batchApply}
\alias{batchApply}
\title{Apply a function to batches of data in an Andromeda table}
\usage{
batchApply(tbl, fun, ..., batchSize = 1e+05, safe = FALSE)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table (or any other 'DBI' table).}

\item{fun}{A function where the first argument is a data frame.}

\item{...}{Additional parameters passed to fun.}

\item{batchSize}{Number of rows to fetch at a time.}

\item{safe}{Create a copy of tbl first? Allows writing to the same Andromeda as being read
from.}
}
\value{
Invisibly returns a list of objects, where each object is the output of the user-supplied function
applied to a batch
}
\description{
Apply a function to batches of data in an Andromeda table
}
\details{
This function is similar to the \code{\link[=lapply]{lapply()}} function, in that it applies a function to sets of
data. In this case, the data is batches of data from an \code{\link{Andromeda}} table. Each batch will be
presented to the function as a data frame.
}
\examples{
andr <- andromeda(cars = cars)

fun <- function(x) {
  return(nrow(x))
}

result <- batchApply(andr$cars, fun, batchSize = 25)

result
# [[1]] 
# [1] 25 
# 
# [[2]] 
# [1] 25

close(andr)

}
