% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Operations.R
\name{restorePosixct}
\alias{restorePosixct}
\title{Restore timestamps}
\usage{
restorePosixct(x)
}
\arguments{
\item{x}{A numeric vector representing timestamps}
}
\value{
A vector of type \code{POSIXct}.
}
\description{
Restores dates that were converted by Andromeda to numeric values back to dates.
}
\examples{
myData <- data.frame(startTime = as.POSIXct(c("2000-01-01 10:00", 
                                              "2001-01-31 11:00", 
                                              "2004-12-31 12:00")))
andr <- andromeda(myData = myData)

andr$myData \%>\% 
  collect() \%>\%
  mutate(startTime = restorePosixct(startTime))
# # A tibble: 3 x 1
# startTime          
# <dttm>             
# 1 2000-01-01 10:00:00
# 2 2001-01-31 11:00:00
# 3 2004-12-31 12:00:00

close(andr)

}
\seealso{
\code{\link[=restoreDate]{restoreDate()}}
}
