% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Indices.R
\name{createIndex}
\alias{createIndex}
\title{Create an index on one or more columns in an Andromeda table}
\usage{
createIndex(tbl, columnNames, unique = FALSE, indexName = NULL)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table (or any other 'DBI' table).}

\item{columnNames}{A vector of column names (character) on which the index is to be created.}

\item{unique}{Should values in the column(s) be enforced to be unique?}

\item{indexName}{The name of the index. If not provided, a random name will be generated.}
}
\value{
Invisibly returns the input table.
}
\description{
Create an index on one or more columns in an Andromeda table
}
\details{
Indices can speed up subsequent queries that use the indexed columns, but can take time to create,
and will take additional space on the drive.
}
\examples{
andr <- andromeda(cars = cars)

createIndex(andr$cars, "speed")

# Will be faster now that speed is indexed:
andr$cars \%>\%
  filter(speed == 10) \%>\%
  collect()

close(andr)

}
\seealso{
\code{\link[=listIndices]{listIndices()}}, \code{\link[=removeIndex]{removeIndex()}}
}
