% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnimalAPD.R
\name{plotAPDcv}
\alias{plotAPDcv}
\title{Plot APDcv Posterior Samples}
\usage{
plotAPDcv(model, histcol = "deeppink", linecol = "black")
}
\arguments{
\item{model}{Output from \code{APDRE} function, an object of class \code{APD}}

\item{histcol}{Colour for histogram}

\item{linecol}{Colour for 95\% HDI line}
}
\value{
Histogram plot of samples from posterior distribution for estimated APDavg
}
\description{
Plot histogram of samples from posterior distribution for estimated APD family-specific population coefficient of variation (CV) from \code{\link{APDRE}} function
}
\examples{
data(wolfexample)
data(boarexample)
\donttest{ WolfBoarAPD<-APDRE(focal=wolfexample$Radians, contingent=boarexample$Radians,
    RE1=wolfexample$SamplingPeriod)
    plotAPDcv(WolfBoarAPD) }

}
