% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_prob.R
\name{ahn_prob}
\alias{ahn_prob}
\title{Plot probability curves}
\usage{
ahn_prob(Dij = seq(0.05, 10, length.out = 30), mu = c(0.1, 2, 5, 10),
  lamda = c(1e-04, 0.15, 0.35, 0.75, 1.25, 5, 30))
}
\arguments{
\item{Dij}{A vector of Euclidean distances between node \code{i} and \code{j}}

\item{mu}{The concave-to-convex transition point of the probability curves \code{P(Dij, mu, lamda) = [1 + exp(-lamda(Dij - mu))]^-1}, where \code{Dij} is the Euclidean distance between node \code{i} and \code{j}}

\item{lamda}{The steepness of the probability curves}
}
\value{
Return a plot with probability curves
}
\description{
Plot the probability curve \code{P(Dij, mu, lamda)} for removing links from the initial complete network
}
\examples{
# plot the probabilities for removing network links between node i and j with
# Euclidean distances Dij

dis <- seq(.05, 10, length.out = 20)
m <- c(.1, 2, 5, 10)
l <- c(.0001, .15, .35, .75, 1.25, 5, 30)
ahn_prob(dis, m, l)

}
