% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_add_node_feature.R
\name{Af_add_node_feature}
\alias{Af_add_node_feature}
\title{Function to add node features to an AntibodyForests-object}
\usage{
Af_add_node_feature(AntibodyForests_object, feature.df, feature.names)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{feature.df}{Dataframe with features for each node. Must contain columns sample_id, clonotype_id, barcode and the features to be added.}

\item{feature.names}{Character vector with the names of the features to be added.}
}
\value{
Returns an AntibodyForests-object with the features added to the nodes.
}
\description{
Function to add node features to an AntibodyForests-object
}
\examples{
af <- Af_add_node_feature(AntibodyForests::small_af,
                          feature.df = AntibodyForests::small_vdj,
                          feature.names = c("VDJ_dgene", "VDJ_jgene"))
}
