% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_plot_PLM.R
\name{Af_plot_PLM}
\alias{Af_plot_PLM}
\title{Function to create a distribution plot of the Protein Language Model probabilities and ranks of the mutations along the edges of B cell lineage trees.}
\usage{
Af_plot_PLM(PLM_dataframe, values, group_by, colors, font.size, output.file)
}
\arguments{
\item{PLM_dataframe}{Dataframe resulting from Af_PLM_dataframe(). This contains the Protein Language Model probabilities and ranks of the mutations along the edges of B cell lineage trees.}

\item{values}{What values to plot. Can be "rank" (default) or "probability".
"substitution_rank" will plot the rank of the mutation along the edge of the tree (Highest probability is rank 1).
"substitution_probability" will plot the probability of the mutation along the edge of the tree.
"original_rank" will plot the rank of the original amino acid at the site of mutation along the edge of the tree (Highest probability is rank 1).
"original_probability" will plot the probability of the original amino acid at the site of mutation along the edge of the tree.}

\item{group_by}{Plot a seperate line per sample or everything together (default).
"sample_id"
"none"}

\item{colors}{Color to use for the lines. When group_by = "sample_id": This should be a vector of the same length as the number of samples.}

\item{font.size}{Font size for the plot. Default is 16.}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A ggplot2 object of the PLM plot
}
\description{
Function to create a distribution plot of the Protein Language Model probabilities and ranks of the mutations along the edges of B cell lineage trees.
}
\examples{
Af_plot_PLM(PLM_dataframe = AntibodyForests::PLM_dataframe,
            values = "original_probability",
            group_by = "sample_id")
}
