% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotApollonius.R
\name{plotApolloniusGraph}
\alias{plotApolloniusGraph}
\title{Plot Apollonius graph}
\usage{
plotApolloniusGraph(
  apo,
  limits = NULL,
  circles = TRUE,
  fill = TRUE,
  centers = TRUE,
  colors = "distinct",
  distinctArgs = list(seedcolors = c("#ff0000", "#00ff00", "#0000ff")),
  randomArgs = list(hue = "random", luminosity = "dark"),
  ...
)
}
\arguments{
\item{apo}{an output of \code{\link{Apollonius}}}

\item{limits}{either \code{NULL} or a vector of length two passed to the
arguments \code{xlim} and \code{ylim} of \code{\link[graphics]{plot}};
if \code{NULL}, automatic limits are calculated}

\item{circles}{Boolean, whether to plot the original sites as circles with
the given radii}

\item{fill}{Boolean, whether to fill the circles if \code{circles=TRUE}
or to plot only their border}

\item{centers}{when \code{circles=TRUE} and \code{fill=FALSE}, whether to
plot the centers of the circles}

\item{colors}{a character string controlling the colors of the sites;
\code{"random"} to get multiple colors with
\code{\link[colorsGen]{randomColor}}, \code{"distinct"} to get multiple
colors with \code{\link[Polychrome]{createPalette}}, or a color name or
a hexadecimal color code}

\item{distinctArgs}{if \code{colors = "distinct"}, a list of arguments
passed to \code{\link[Polychrome]{createPalette}}}

\item{randomArgs}{if \code{colors = "random"}, a list of arguments passed
to \code{\link[colorsGen]{randomColor}}}

\item{...}{arguments passed to \code{\link[graphics]{plot}}, such as
\code{xlab} and \code{ylab}}
}
\value{
No returned value, called for plotting.
}
\description{
Plot an Apollonius graph.
}
\examples{
library(Apollonius)
sites <- rbind(
  c(0, 0),
  c(4, 1),
  c(2, 4),
  c(7, 4),
  c(8, 0),
  c(5, -2),
  c(-4, 4),
  c(-2, -1),
  c(11, 4),
  c(11, 0)
)
radii <- c(1, 1.5, 1.25, 2, 1.75, 0.5, 0.4, 0.6, 0.7, 0.3)
apo <- Apollonius(sites, radii)
opar <- par(mar = c(3, 3, 1, 1))
plotApolloniusGraph(
  apo, fill = FALSE, colors = "random", xlab = NA, ylab = NA
)
par(opar)
}
