% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_functions.R
\name{select}
\alias{select}
\title{Selection}
\usage{
select(
  gen,
  batch = 0,
  select_on = "Index",
  trait,
  Ntraits = BPdata$Ntraits,
  Nm = BPdata$Nm,
  Nf = BPdata$Nf,
  max_FSfam = "all",
  mature_m = 1,
  mature_f = 1,
  selected = 1
)
}
\arguments{
\item{gen}{The generation of the selection candidates. A vector with multiple generations can be provided.}

\item{batch}{The batch of the selection candidates. Default is 0. It is possible to provide a vector with multiple batches.}

\item{select_on}{Options: "Index", "EBV" or "Phenotype". For "EBV" and "Phenotype", also the trait need to be specified in 'trait'. Default is Index.}

\item{trait}{Which trait or EBV the selection is base on when option "EBV" or "Phenotype" is choosen in 'select_on'.}

\item{Ntraits}{Number of simulated traits. Does not need to be specified if Ntraits is specified in a list called 'BPdata'.}

\item{Nm}{Number of males to select.}

\item{Nf}{Number of females to select.}

\item{max_FSfam}{Maximum number of sibs that can be selected per full sib familie. Default is 'all'.}

\item{mature_m}{Proportion of male selection candidates that is assumed to be mature and available at the moment of selection. Default is 1}

\item{mature_f}{Proportion of female selection candidates that is assumed to be mature and available at the moment of selection. Default is 1}

\item{selected}{The value assigned to ped$selected for the selected animals, default is 1.}
}
\value{
This function will change the data frame called 'ped'. Fish that are selected will be assigned a value to their column 'selected'.
}
\description{
Function to select selection candidates based on their Index, EBV or phenotype. ped$selcand should be 1 for the selection candidates.
}
\examples{
\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}

ped <- preselphen(gen = 1,
                  Nenv = 2,
                  Npresel = c(25,15),
                  trait = 1,
                  Ntraits = 2)
                  
ped <- avail_selection(gen = 1,
                       presel = 1,
                       surv = 0.9)
                       
ped <- breeding_values(gen = 1,
                       TraitsIndex = 2,
                       EBV = "GEBV",
                       GenomLength = 11.3,
                       Ne = 100,
                       SizeTraining = nrow(ped[ped$preselected ==2,]),
                       Ntraits = 2,
                       a_var = c(200,8000),
                       h2 = c(0.33,0.38))
                       
ped <- select(gen=1,
                 Nm = 60,
                 Nf = 60,
                 mature_m = 0.5,
                 mature_f = 0.4,
                 Ntraits = 2)
}
}
