% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{getmasses}
\alias{getmasses}
\alias{getmasses.default}
\alias{getmasses.logratios}
\alias{getmasses.timeresolved}
\title{Select a subset of isotopes from a dataset}
\usage{
getmasses(x, ...)

\method{getmasses}{default}(x, ...)

\method{getmasses}{timeresolved}(x, mass, invert = FALSE, ...)

\method{getmasses}{logratios}(x, num, den, invert = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{\link{logratios}},
\code{\link{timeresolved}}, \code{\link{PHdata}} or
\code{\link{redux}}.}

\item{...}{other arguments}

\item{mass}{a vector of strings denoting the masses of interest}

\item{invert}{boolean parameter indicating whether the selection
should be inverted (default = FALSE)}

\item{num}{vector of strings indicating the numerator isotopes}

\item{den}{vector of string indicating the denominator isotopes}
}
\value{
an object of the same class as x
}
\description{
Extracts the intercepts, covariance matrix, etc. of a selection of
isotopes from a larger dataset
}
\examples{
kfile <- system.file("K-glass.csv",package="ArArRedux")
masses <- c("Ar37","Ar38","Ar39","Ar40","Ar36")
mk <- loaddata(kfile,masses)
lk <- fitlogratios(blankcorr(mk,"EXB#","K:"),"Ar40")
k <- getmasses(lk,"Ar39","Ar40") # subset on the relevant isotopes
plotcorr(k$covmat)
}

