% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_t0.R
\name{estimate_t0}
\alias{estimate_t0}
\title{Estimates the intervention time on a given treated unity}
\usage{
estimate_t0(data, fn, p.fn, start = 0.4, end = 0.9, treated.unity = 1,
  lag = 0, Xreg = NULL)
}
\arguments{
\item{data}{A list of matrixes or data frames of length q. Each matrix is T X n and it contains observations of a single variable for all units and all periods of time. Even in the case of a single variable (q=1), the matrix must be inside a list.}

\item{fn}{The function used to estimate the first stage model. This function must receive only two arguments in the following order: X (independent variables), y (dependent variable). If the model requires additional arguments they must be supplied inside the function fn. If not supplied the default is the lm function.}

\item{p.fn}{The forecasting function used to estimate the counterfactual using the first stage model (normally a predict funtion). This function also must receive only two arguments in the following order: model (model estimated in the first stage), newdata (out of sample data to estimate the second stage). If the prediction requires additional arguments they must be supplied inside the function p.fn.}

\item{start}{Initial value of \eqn{\lambda_0} to be tested.}

\item{end}{Final value of \eqn{\lambda_0} to be tested.}

\item{treated.unity}{Single number indicating the unity where the intervention took place.}

\item{lag}{Number of lags in the first stage model. Default is 0, i.e. only contemporaneous variables are used.}

\item{Xreg}{Exogenous controls.}
}
\value{
A list with the following items:
\item{t0}{Estimated t0.}
\item{delta.norm}{The norm of the delta corresponding to t0.}
\item{call}{The matched call.}
}
\description{
Estimates the intervention time on a given treated unity based on any model supplied by the user.
}
\details{
This description may be useful to clarify the notation and understand how the arguments must be supplied to the functions.
\itemize{
\item{units: }{Each unity is indexed by a number between \eqn{1,\dots,n}. They are for exemple: countries, states, municipalities, firms, etc.}
\item{Variables: }{For each unity and for every time period \eqn{t=1,\dots,T} we observe \eqn{q_i \ge 1} variables. They are for example: GDP, inflation, sales, etc.}
\item{Intervention: }{The intervention took place only in the treated unity at time \eqn{t_0=\lambda_0*T}, where \eqn{\lambda_0} is in (0,1).}
}
}
\examples{
#############################
## === Example for q=1 === ##
#############################
data(data.q1) 
# = First unity was treated on t=51 by adding
# a constant equal to one standard deviation.

data=list(data.q1) # = Even if q=1 the data must be in a list

## == Fitting the ArCo using linear regression == ##

# = creating fn and p.fn function = #
fn=function(X,y){
    return(lm(y~X))
}
p.fn=function(model,newdata){
    b=coef(model)
    return(cbind(1,newdata)\%*\%b)
}

t0a=estimate_t0(data = data,fn = fn, p.fn = p.fn, treated.unity = 1 )


#############################
## === Example for q=2 === ##
#############################

# = First unity was treated on t=51 by adding constants of one standard deviation.
# for the first and second variables
data(data.q2) # data is already a list

## == Detecting lambda0 using the package glmnet via LASSO and crossvalidation == ##

t0b=estimate_t0(data = data.q2,fn = fn, p.fn = p.fn, treated.unity = 1, start=0.4)
}
\seealso{
\code{\link{fitArCo}}
}
