% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{ImportCSV}
\alias{ImportCSV}
\title{Importing a CSV file containing the output of the MCMC algorithm}
\usage{
  ImportCSV(file, dec = '.', sep=',', comment.char='#', header = TRUE)
}
\arguments{
  \item{file}{the name of the CSV file containing the output of the MCMC algorithm}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
  \item{header}{a logical value indicating whether the file contains the names of the variables as its first line. }
}
\value{
  Returns a dataframe containing a representation of the data in the file.
}
\description{
  Use of the read.csv with th default values for CSV files extracted from ChronoModel software
  }
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and
  
  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Events)
  write.csv(Events, "data.csv", row.names=FALSE)
  ImportCSV("data.csv")
  ImportCSV("data.csv", dec = '.', sep=',', comment.char='#', header = TRUE)
}
\keyword{ CSV file}
