% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiDatesPlot.R
\name{multi_dates_plot}
\alias{multi_dates_plot}
\title{Plot of credible intervals or HPD regions of a series of events}
\usage{
multi_dates_plot(
  data,
  position = 1:ncol(data),
  level = 0.95,
  plot_result = TRUE,
  round = 0,
  intervals = "CI",
  order = "default",
  title = "Plot of intervals",
  subtitle = NULL,
  caption = "ArchaeoPhases",
  x_label = "Calendar Year",
  y_label = NULL,
  height = 7,
  width = 7,
  units = "in",
  x_min = NULL,
  x_max = NULL,
  x_scale = "calendar",
  elapsed_origin_position = NULL,
  dumbbell_size = 1,
  dot_guide = FALSE,
  dot_guide_size = 0.25,
  y_grid = FALSE,
  file = NULL,
  new_window = TRUE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the positions of the columns
corresponding to the MCMC chains of interest, or a vector of column
names.}

\item{level}{Probability corresponding to the level of confidence.}

\item{plot_result}{If \code{TRUE}, then draw a plot on the display,
else suppress drawing.}

\item{round}{Integer indicating the number of decimal places to be used.}

\item{intervals}{One of "CI" for credible intervals, or "HPD" for highest
posterior density intervals.}

\item{order}{Order of the events. If "default" then the order of the csv file
is followed, if "increasing" events are ordered by the HPDInf of the
first region or the CIInf}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{x_label}{X axis label of the plot.}

\item{y_label}{Y axis label of the plot.}

\item{height}{Height of the plot in \code{units}.}

\item{width}{Width of the plot in \code{units}.}

\item{units}{A string recognized by \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{x_min}{Minimum x axis value.}

\item{x_max}{Maximum x axis value.}

\item{x_scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for years after a specified origin.}

\item{elapsed_origin_position}{Position of the column corresponding
to the origin for elapsed time calculations.}

\item{dumbbell_size}{Size of the symbols used to plot events.}

\item{dot_guide}{Switch for guides from y-axis to plot symbols.}

\item{dot_guide_size}{Size of the dot guides.}

\item{y_grid}{Switch for horizontal grids.}

\item{file}{Name of the file to be saved. If \code{NULL} then no plot is saved.}

\item{new_window}{Whether the plot is drawn within a new window or not.}
}
\value{
An \code{archaeophases_plot} object with the data and metadata
needed to reproduce the plot.
}
\description{
Plot of credible intervals or HPD regions of a series of events
}
\examples{
  data(Events)
  multi_dates_plot(Events, c(2, 4, 3), level = 0.95, intervals = "CI",
                 title = "Plot of CI intervals")
  multi_dates_plot(Events, c(2, 4, 3), level = 0.95, intervals = "HPD",
                 title = "Plot of HPD intervals")
  multi_dates_plot(Events, c(2, 4, 3), level = 0.95, intervals = "HPD",
                 order = "increasing")

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
