% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhaseDurationPlot.R
\name{PhaseDurationPlot}
\alias{PhaseDurationPlot}
\title{Plot the duration of a group}
\usage{
PhaseDurationPlot(
  PhaseMin_chain,
  PhaseMax_chain,
  level = 0.95,
  title = "Duration of a group of dates",
  colors = TRUE,
  exportFile = NULL,
  exportFormat = "PNG",
  GridLength = 1024
)
}
\arguments{
\item{PhaseMin_chain}{Numeric vector containing the output of the MCMC
algorithm for the minimum of the events included in the phase.}

\item{PhaseMax_chain}{Numeric vector containing the output of the MCMC
algorithm for the maximum of the events included in the phase.}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval and the time range.}

\item{title}{Title of the plot.}

\item{colors}{If \code{TRUE}, use colors in the plot,
otherwise produce a black and white plot.}

\item{exportFile}{Name of the file to be saved. If \code{NULL}, then no plot is saved.}

\item{exportFormat}{Format of the export file, either "PNG" or "SVG".}

\item{GridLength}{Length of the grid used to estimate the density.}
}
\value{
\code{NULL}, called for its side effects
}
\description{
This function draws the marginal posterior densities of the time elapsed
between the minimum and the maximum of the dates included in a phase,
and adds summary statistics (mean, CI)
}
\details{
Plot of the density of the time elapsed between the minimum and the
maximum calendar years of the events included in a phase, along with
mean and credible interval
}
\examples{
  data(Phases); attach(Phases)
  PhaseDurationPlot(Phase.1.alpha, Phase.1.beta, 0.95, "Duration of Phase 1")
  PhaseDurationPlot(Phase.2.alpha, Phase.2.beta, 0.95, "Duration of Phase 2", colors = FALSE)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
