% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dec.curve.R
\name{dec.curve}
\alias{dec.curve}
\title{dec.curve}
\usage{
dec.curve(mat_input, mag, plot = TRUE)
}
\arguments{
\item{mat_input}{numeric: a kx3 matrix}

\item{mag}{numeric: how many times will be divided by the number of initial points}

\item{plot}{logical: if TRUE will be plotted the starting and final point matrices}
}
\value{
matt numeric: a kx3 matrix with points coordinates
}
\description{
This function computes the order of points on a open 3D curve and finds intermediate points
}
\examples{
## Create and plot a 3D curve
require(compositions)
require(rgl)
curve_3D<-cbind(1:10,seq(1,5,length=10),rnorm(10,sd = 0.2))
plot3D(curve_3D,bbox=FALSE)
rgl.close()
## Create and plot the new 3D curve (with intermediate points)
dec_curve_3D<-dec.curve(curve_3D, 2, plot = TRUE)
}
\author{
Antonio Profico, Alessio Veneziano, Marina Melchionna, Pasquale Raia
}
