% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CScorreffect.R
\name{CScorreffect}
\alias{CScorreffect}
\title{CScorreffect
Plot showing the correlation in the shape space between original and combined dataset omitting or including the normalization factors calculated with Arothron and MLECScorrection}
\usage{
CScorreffect(
  array1,
  array2,
  nPCs = c(1:3),
  from = 0.02,
  to = 0.9,
  length.out = 100
)
}
\arguments{
\item{array1}{array: first set of landmark configuration}

\item{array2}{array: second set of landmark configuration}

\item{nPCs}{numeric vector: specify which PC scores will be selected in the correlation test}

\item{from}{numeric: the lower interval of the normalization factor distribution}

\item{to}{numeric: the lower interval of the normalization factor distribution}

\item{length.out}{numeric: number of values ranged between from and to}
}
\value{
PCscores PCscores matrix of the combined dataset applying the normalization factor calculated by using the maximum likelihood estimation

PCs PCs matrix of the combined dataset applying the normalization factor calculated by using the maximum likelihood estimation

corr mean correlation between original and combined dataset

CSratios normalization factor calculated by using the maximum likelihood estimation
}
\description{
CScorreffect
Plot showing the correlation in the shape space between original and combined dataset omitting or including the normalization factors calculated with Arothron and MLECScorrection
}
\examples{
\dontrun{
# Femora case study
data(femsets)
all_pois<-matrix(1:(200*61),nrow=61,ncol=200,byrow = FALSE)
set_ext_100<-femsets[all_pois[,1:100],,]

set_int_100<-femsets[all_pois[,101:200],,]
set_int_50<-set_int_100[c(matrix(1:6100,ncol=61)[seq(1,100,2),]),,]
set_int_20<-set_int_100[c(matrix(1:6100,ncol=61)[seq(1,100,5),]),,]
set.seed(123)
sel<-sample(1:100,10)
set_int_10r<-set_int_100[c(matrix(1:6100,ncol=61)[sel,]),,]

CScorreffect(set_ext_100,set_int_50,nPCs=1:3)
CScorreffect(set_ext_100,set_int_20,nPCs=1:3)
CScorreffect(set_ext_100,set_int_10r,nPCs=1:3)
}
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
