% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AzureToken.R, R/classes.R
\docType{class}
\name{AzureToken}
\alias{AzureToken}
\alias{AzureTokenAuthCode}
\alias{AzureTokenDeviceCode}
\alias{AzureTokenClientCreds}
\alias{AzureTokenOnBehalfOf}
\alias{AzureTokenResOwner}
\alias{AzureTokenManaged}
\title{Azure OAuth authentication}
\format{An R6 object representing an Azure Active Directory token and its associated credentials. \code{AzureToken} is the base class, and the others inherit from it.}
\usage{
AzureToken

AzureTokenAuthCode

AzureTokenDeviceCode

AzureTokenClientCreds

AzureTokenOnBehalfOf

AzureTokenResOwner

AzureTokenManaged
}
\description{
Azure OAuth 2.0 token classes, with an interface based on the \link[httr:Token2.0]{Token2.0 class} in httr. Rather than calling the initialization methods directly, tokens should be created via \code{\link[=get_azure_token]{get_azure_token()}}.
}
\section{Methods}{

\itemize{
\item \code{refresh}: Refreshes the token. For expired tokens without an associated refresh token, refreshing really means requesting a new token.
\item \code{validate}: Checks if the token has not yet expired. Note that a token may be invalid for reasons other than having expired, eg if it is revoked on the server.
\item \code{hash}: Computes an MD5 hash on the input fields of the object. Used internally for identification purposes when caching.
\item \code{cache}: Stores the token on disk for use in future sessions.
}
}

\seealso{
\link{get_azure_token}, \link[httr:Token]{httr::Token}
}
\keyword{datasets}
