% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AzureAuth.R
\name{AzureR_dir}
\alias{AzureR_dir}
\title{Data directory for AzureR packages}
\usage{
AzureR_dir()
}
\value{
A string containing the data directory.
}
\description{
Data directory for AzureR packages
}
\details{
AzureAuth saves your authentication credentials in a user-specific directory, so you don't have to reauthenticate in every R session. The default location is determined using the rappdirs package: on recent Windows versions, this will usually be in the location \verb{C:\\\\Users\\\\(username)\\\\AppData\\\\Local\\\\AzureR}; on Unix/Linux, it will be in \verb{~/.local/share/AzureR}; and on MacOS, it will be in \verb{~/Library/Application Support/AzureR}. Alternatively, you can specify the location of the directory in the environment variable \code{R_AZURE_DATA_DIR}. AzureAuth does not modify R's working directory, which significantly lessens the risk of accidentally introducing cached tokens into source control.

This directory is also used by other AzureR packages, notably AzureRMR (for storing Resource Manager logins) and AzureGraph (for Microsoft Graph logins). You should not save your own files in it; instead, treat it as something internal to the AzureR packages.
}
\seealso{
\link{get_azure_token}

\link[rappdirs:user_data_dir]{rappdirs::user_data_dir}
}
