% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_auth.R
\docType{class}
\name{az_rm}
\alias{az_rm}
\title{Azure Resource Manager}
\format{An R6 object of class \code{az_rm}.}
\usage{
az_rm
}
\description{
Base class for interacting with Azure Resource Manager.
}
\section{Methods}{

\itemize{
\item \code{new(tenant, app, ...)}: Initialize a new ARM connection with the given credentials. See 'Authentication` for more details.
\item \code{list_subscriptions()}: Returns a list of objects, one for each subscription associated with this app ID.
\item \code{get_subscription(id)}: Returns an object representing a subscription.
}
}

\section{Authentication}{

To authenticate with ARM, provide the following arguments to the \code{new} method:
\itemize{
\item \code{tenant}: Your tenant ID.
\item \code{app}: Your client/app ID which you registered in Azure Active Directory.
\item \code{auth_type}: Either \code{"client_credentials"} (the default) or \code{"device_code"}.
\item \code{password}: if \code{auth_type == "client_credentials"}, your password.
\item \code{host}: your ARM host. Defaults to \code{https://management.azure.com/}. Change this if you are using a government or private cloud.
\item \code{aad_host}: Azure Active Directory host for authentication. Defaults to \code{https://login.microsoftonline.com/}. Change this if you are using a government or private cloud.
\item \code{config_file}: Optionally, a JSON file containing any of the arguments listed above. Arguments supplied in this file take priority over those supplied on the command line. You can also use the output from the Azure CLI \code{az ad sp create-for-rbac} command.
\item \code{token}: Optionally, an OAuth 2.0 token, of class \link{AzureToken}. This allows you to reuse the authentication details for an existing session. If supplied, all other arguments will be ignored.
}
}

\examples{
\dontrun{

# start a new Resource Manager session
az <- az_rm$new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")

# authenticate with credentials in a file
az <- az_rm$new(config_file="creds.json")

# authenticate with device code
az <- az_rm$new(tenant="myaadtenant.onmicrosoft.com", app="app_id", auth_type="device_code")

# retrieve a list of subscription objects
az$list_subscriptions()

# a specific subscription
az$get_subscription("subscription_id")

}
}
\seealso{
\link{get_azure_token}, \link{AzureToken},
\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-overview}{Azure Resource Manager overview},
\href{https://docs.microsoft.com/en-us/rest/api/resources/}{REST API reference}
}
\keyword{datasets}
