% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vnet_config.R
\name{vnet_config}
\alias{vnet_config}
\alias{subnet_config}
\title{Virtual network configuration}
\usage{
vnet_config(address_space = "10.0.0.0/16",
  subnets = list(subnet_config()), ...)

subnet_config(name = "subnet", addresses = "10.0.0.0/16",
  nsg = "[variables('nsgId')]", ...)
}
\arguments{
\item{address_space}{For \code{vnet_config}, the address range accessible by the virtual network, expressed in CIDR block format.}

\item{subnets}{For \code{vnet_config}, a list of subnet objects, each obtained via a call to \code{subnet_config}.}

\item{...}{Other named arguments that will be treated as resource properties.}

\item{name}{For \code{subnet_config}, the name of the subnet. Duplicate names will automatically be disambiguated prior to VM deployment.}

\item{addresses}{For \code{subnet_config}, the address ranges spanned by this subnet. Must be a subset of the address space available to the parent virtual network.}

\item{nsg}{The network security group associated with this subnet. Defaults to the NSG created as part of this VM deployment.}
}
\description{
Virtual network configuration
}
\examples{
vnet_config()
vnet_config(address_space="10.1.0.0/16")
vnet_config(subnets=list(
    subnet_config("subnet", "10.0.0.0/24")
))
}
\seealso{
\link{create_vm}, \link{vm_config}, \link{vmss_config}
}
