% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_regions.R
\name{add_image_regions}
\alias{add_image_regions}
\alias{customvision_regions}
\alias{remove_image_regions}
\alias{identify_regions}
\title{Add and remove regions from images}
\usage{
add_image_regions(project, image_ids, regions)

remove_image_regions(project, image_ids, region_ids = NULL)

identify_regions(project, image)
}
\arguments{
\item{project}{A Custom Vision object detection project.}

\item{image_ids}{For \code{add_image_regions} and \code{remove_image_regions}, the IDs of the images for which to add or remove regions.}

\item{regions}{For \code{add_image_regions}, the regions to add. See 'Details' below.}

\item{region_ids}{For \code{remove_image_regions}, a vector of region IDs. This is an alternative to image ID for specifying the regions to remove; if this is provided, \code{image_ids} is not used.}

\item{image}{For \code{identify_regions}, an image for which to identify possible regions in which an object exists. This can be the ID of an image that was previously uploaded to the project; if not, the image is uploaded. Otherwise, see \code{add_images} for how to specify an image to upload.}
}
\value{
For \code{add_image_regions}, a data frame containing the details on the added regions.

For \code{remove_image_regions}, the value of \code{image_ids} invisibly, if this argument was provided; NULL otherwise.

For \code{identify_regions}, a list with the following components: \code{projectId}, the ID of the project; \code{imageId}, the ID of the image; and \code{proposals}, a data frame containing the coordinates of each identified region along with a confidence score.
}
\description{
Add and remove regions from images
}
\details{
\code{add_image_regions} and \code{remove_image_regions} let you specify the regions in an image that contain an object. You can use \code{identify_regions} to have Custom Vision try to guess the regions for an image.

The regions to add should be specified as a list of data frames, with one data frame per image. Each data frame should have one row per region, and the following columns:
\itemize{
\item \code{left}, \code{top}, \code{width}, \code{height}: the location and dimensions of the region bounding box, normalised to be between 0 and 1.
\item \code{tag}: the name of the tag to associate with the region.
Any other columns in the data frame will be ignored.
}
}
\examples{
\dontrun{

img_ids <- add_images(myproj, c("catanddog.jpg", "cat.jpg", "dog.jpg"))

regions <- list(
    data.frame(
        tag=c("cat", "dog"),
        left=c(0.1, 0.5),
        top=c(0.25, 0.28),
        width=c(0.24, 0.21),
        height=c(0.7, 0.6)
    ),
    data.frame(
        tag="cat", left=0.5, top=0.35, width=0.25, height=0.62
    ),
    data.frame(
        tag="dog", left=0.07, top=0.12, width=0.79, height=0.5
    )
)

add_image_regions(myproj, img_ids, regions)
remove_image_regions(myproj, img_ids[3])
add_image_regions(myproj, img_ids[3],
    list(data.frame(
        tag="dog", left=0.5, top=0.12, width=0.4, height=0.7
    ))
)

}
}
\seealso{
\code{\link{add_images}}, \code{\link{add_tags}}

\code{\link{add_image_tags}} for classification projects
}
