% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{extractsamples}
\alias{extractsamples}
\title{Extract MCMC samples for parameters from an angmcmc object}
\usage{
extractsamples(object, par.name, comp.label, chain.no, drop = TRUE, ...)
}
\arguments{
\item{object}{angular MCMC object}

\item{par.name}{vector of names of parameters for which point estimates are to be computed.  If \code{NULL}, results for all parameters are provided.}

\item{comp.label}{vector of component labels (positive integers, e.g., \code{1, 2, ...}) for which point estimates are to be computed.
If \code{NULL}, results for all components are provided.}

\item{chain.no}{vector of chain numbers whose samples are to be be used.
in the estimation. By default all chains are used.}

\item{drop}{logical. Should the dimension of the output be dropped, if \code{par.name},
\code{comp.label} or \code{chain.no} has a single level?}

\item{...}{additional arguments to be passed to the function.}
}
\value{
Returns  a four dimensional array with

dimension 1 - model parameters and mixing proportions
dimention 2 - components
dimension 3 - MCMC iterations
dimension 4 - chain number
}
\description{
Extract MCMC samples for parameters from an angmcmc object
}
\details{
The default for both \code{par.name} and \code{comp.label} are the all possible choices
available in \code{object}.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# extract Markov chain realizations for kappa1 from component 1
extr_kappa1_1 <- extractsamples(fit.vmsin.20, "kappa1", 1)
# for kappa1 from component from all components
extr_kappa1 <- extractsamples(fit.vmsin.20, "kappa1")
# for all parameters in component 1
extr_1 <- extractsamples(fit.vmsin.20, comp.label = 1)

}
