% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Networks.Fast}
\alias{Networks.Fast}
\title{Bayesian Network Discovery using a Hybrid Fast Algorithm}
\description{
This function implements a hybrid fast algorithm to perform feature selection and sub-network discovery using a Bayesian nonparametric model based on Dirichlet process mixture models, finite mixture of normals model and the Ising model.  

}


\usage{
Networks.Fast(pvalue,net,iter=5000,nburns=2000,
algorithms=c("EM","DPM"),
v=20,DPM.mcmc=list(nburn=2000,nsave=1,nskip=0,ndisplay=10),
DPM.prior=list(a0=2,b0=1,m2=rep(0,1),s2=diag(100000,1),
psiinv2=solve(diag(0.5,1)),
nu1=4,nu2=4,tau1=1,tau2=100),
DPparallel=FALSE,n.cores=1,piall=c(0.8, 0.85, 0.9, 0.95),
rhoall=c(1, 2, 5, 10, 15),
show.steps=10,showlikelihood=FALSE, likelihood.frequency=100)
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{net}{an "n"" by "n" binary (0/1) adjacent matrix of network configurations, where n=length(pvalue)}

\item{iter}{number of iterations; the default is 5000}

\item{nburns}{number of burn-in; the default is 2000}

\item{algorithms}{character taking value "EM" or "DPM" indicating the function to be used to obtain Finite Gaussian Mixture (FGM) estimates. It is recommended to choose "DPM" when the dimension of data is large, and to choose "EM" when the dimension is small.}

\item{v}{number of iterations set for DPM fitting. v is only valid when you choose \code{algorithms} as "DPdensity"}

\item{DPM.mcmc}{a list giving the MCMC a list giving the MCMC parameters for DPM fitting; see the argument \code{mcmc} of function \code{DPdensity()} in \code{DPpackage} for details; the default setting is \code{DPM.mcmc=list(nburn=2000,nsave=1,nskip=0,ndisplay=10)}}

\item{DPM.prior}{a list giving the prior information; see the argument \code{prior} of function \code{DPdensity()} in \code{DPpackage} for details; the default setting is \code{prior2}}

\item{piall}{a vector of possible choices for "pi0" in an increasing order; the default value is c(0.75, 0.8, 0.85, 0.9)}

\item{rhoall}{a vector of possible choices of "rho0" and "rho1" in an increasing order; the default value is c(0.5, 1, 5, 10, 15)
}
\item{DPparallel}{the logic variable indicating whether apply parallel computing when you set \code{algorithms="DPM"}; the default setting is FALSE
}
\item{n.cores}{number of CUP cores for parallel computing, this argument is only valid when you set \code{algorithms="DPM"}; the default setting is 1
}

\item{show.steps}{integer representing the frequency of the results of iterations presented, the default setting is 10. The setting is invalid when \code{trace=FALSE}. The setting would not affect the data saved, only for printing}

\item{showlikelihood}{a logical variable indicating whether to show the log-likelihood value simultaneously.Set \code{TRUE} if show the log-likelihood value simultaneously, \code{FALSE}, otherwise. \code{FALSE} is the default setting}

\item{likelihood.frequency}{a number representing the frequency showing the log-likelihood value simultaneously. For example, setting \code{likelihood.frequency=100} means showing the log-likelihood value every 100 iterations. The default setting is 100 and it is recommended that do not set a small frequency because it slow down the MCMC chain updating}
}

\value{a list of values containing the posterior samples of "z_i" and summary statistics
\describe{
\item{trace}{an length(pvalue) by (iter-nburns) matrix}
\item{statistics}{a list of summary statistics characterizing the posterior distribution of "z_i"
\describe{
\item{mean}{posterior mean for each feature}
\item{median}{posterior median  for each feature}
\item{var}{posterior variance for each feature}
\item{quantile}{posterior quantiles for each feature}}}
}
}

\details{
This function implements a Bayesian nonparametric mixture model for feature selection incorporating network information (Zhao et al., 2014):
\itemize{
\item  r_i| g_i, \strong{theta} ~ N(mu_{g_i}, sigma_{g_i}),
\item  g_i | z_i=k, \strong{q}_k ~ Discrete(\strong{a}_k, \strong{q}_k),
\item	\strong{theta} ~ G_{0k}, for g in \strong{a}_k,
\item	\strong{q}_k ~ Dirichlet(tau_k \strong{1}_{\{L_k\}}/L_k),
\item	\strong{theta}=\{{\strong{theta}_g}\}_{\{g in \strong{a}_0 and \strong{a}_1\}}
\item	\strong{theta}_g=(mu_g, sigma_g)
}
where we define
\describe{
\item{Index}{\strong{a}_0=(-L_0+1,-L_0+2,...,0) , \strong{a}_1=(1,2,...,L_1) and the correspondent probability q_0=(q_{-L_0+1}, q_{-L_0+2}, ...,q_0), q_1=(q_1, q_2, ..., q_{L_1}), according to the definition of Discrete(\strong{a}_k, \strong{b}_k), for example, Pr(g_i={L_0+2})=q_{-L_0+2}. }
\item{Assumption}{In this algorithm, we assume that "important" features should have larger statics comparing to "unimportant" ones without the loss of generality. In this regard, we set the restriction mu_g<mu_{g+1} for g=-L_0+1, -L_0+2,...,L_1.}
}
This function implements the NET-DPM-3 Zhao et al.(2014). Please refer to the Appendix B.3 for more details. 
}

\references{
Zhao, Y., Kang, J., Yu, T. A Bayesian nonparametric mixture model for selecting gene and gene-sub network, Annals of Applied Statistics, In press: 2014.

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BANFF: an R package for network identifications via Bayesian nonparametric mixture models, working paper.

}

\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao


Department of Biostatistics and Bioinformatics, Emory University
}



\examples{
####Gene Network discovery
##Generating Scale free Gene Network
library(igraph)
library(BANFF)
g <- barabasi.game(50, power=1, zero.appeal=1.5,directed = FALSE)
net=as(get.adjacency(g,attr=NULL),"matrix")
##Random assign selected genes and make the signal intension as gaussian mixture
newz=rep(c(1,0,0,1,0),10)
Simnorm=function(n){
weight = c(0.4, 0.6)
mu = c(8,6)
sigma = c(1,0.5)
z = sample(c(1,2),size=n, prob=weight,replace=TRUE)
r = rnorm(n,mean=mu[z],sd=sigma[z])
return(r)
}
testcov<-0
for(i in 1:50){
 if(newz[i]==0){
   testcov[i]<-rnorm(1,mean=0,sd=1)
 }else{
  testcov[i]<-Simnorm(1)
 }
}
pvalue=pnorm(-testcov)
total1=Networks.Fast(pvalue,net,iter=5,nburns=2,
v=20,algorithms="DPM",DPparallel=FALSE,
piall=c(0.8, 0.85, 0.9, 0.95),rhoall=c(1, 2, 5, 10, 15)
)
}

