\name{Subnetwork.Select}
\alias{Subnetwork.Select}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Summarize the information of the sub networks selected by \code{Network.Fast()} and \code{Network.STD()}
}
\description{
This function is to Summarize the information of the sub networks selected by \code{Network.Fast()} and \code{Network.STD()}. If the marginal distribution of a certain node is larger than 0.5, we consider this node as selected. The aim of this function is to customize the process of summarizing.
}
\usage{
Subnetwork.Select(net,trace,node.based=NULL,infinite=TRUE,steps=5)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{
an "n" by "n" binary (0/1) adjacent matrix of network configurations, where n=length(pvalue); 
same as the argument \code{net} in function \code{Network.STD} and \code{Network.Fast} 
}
\item{trace}{the trace (results of each iteration) generated by the functions \code{Networks.STD()} and \code{Networks.Fast()}.Please set as \code{trace=total$trace} where \code{total} is the output of the two functions, \code{Networks.STD()} and \code{Networks.Fast()}; you can also provide a binary 1 by "n" matrix representing the "important"(1) and "unimportant"(0) nodes}
\item{node.based}{a vector representing the orders of the nodes the sub network centered}
\item{infinite}{a logical variable indicating whether the expanding of sub network in a "infinite" pattern or not; \code{infinite=TRUE} if searching the "important" sub network based on one node without the limitation of maximum steps; \code{infinite=FALSE} if searching the sub network under a regulated way}
\item{steps}{a number representing the maximum steps for expanding the sub network}
}

\value{
a list of values containing the the information of the sub networks selected by \code{Network.Fast()} and \code{Network.STD()}
\describe{
\item{eids}{a vector of order representing the selected nodes}
\item{adj}{a "m" by "m" binary adjacent matrix of the sub network configurations where n=length(eids)
}}
}

