\name{Plot.Subnetwork}
\alias{Plot.Subnetwork}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plotting the Network Feature Selected
%%  ~~function to do ... ~~
}
\description{
This is a supportive function for plotting the network feature according to the outputs of \code{Network.STD} and \code{Network.Fast}. If the mean of the marginal distribution of a certain node is larger than 0.5, we consider this node as selected. 
}
\usage{
Plot.Subnetwork(net,trace)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{
an "n" by "n" binary (0/1) adjacent matrix of network configurations, where n=length(pvalue); 
same as the argument \code{net} in function \code{Network.STD()} and \code{Network.Fast()} 
}
\item{trace}{the trace (results of each iteration) generated by the functions \code{Networks.STD()} and \code{Networks.Fast()}.Please set as \code{trace=total$trace} where \code{total} is the output of the two functions, \code{Networks.STD()} and \code{Networks.Fast()}}

}

\value{
A plot of the network feature selected
}
\examples{
library(igraph)
g=barabasi.game(10,power=0.5)
net=as(get.adjacency(g),"matrix")
trace=matrix(c(rep(1,5),rep(0,5)),nrow=1)
Plot.Subnetwork(net,trace)
}



