% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{coef.bas}
\alias{coef.bas}
\alias{coef}
\alias{coefficients}
\alias{coefficients.bas}
\alias{print.coef.bas}
\alias{print.coef.bas}
\title{Coefficients of a Bayesian Model Average object}
\usage{
\method{coef}{bas}(object, n.models, estimator = "BMA", ...)

\method{print}{coef.bas}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{object of class 'bas' created by BAS}

\item{n.models}{Number of top models to report in the printed summary, for
coef the default is to use all models.  To extract summaries for the Highest
Probability Model, use n.models=1 or estimator="HPM".}

\item{estimator}{return summaries for a selected model, rather than using
BMA.  Options are 'HPM' (highest posterior probability model) ,'MPM' (median
probability model), and 'BMA'}

\item{...}{other optional arguments}

\item{x}{object of class 'coef.bas' to print}

\item{digits}{number of significant digits to print}
}
\value{
\code{coefficients} returns an object of class coef.bas with the
following: \item{conditionalmeans}{a matrix with conditional posterior means
for each model} \item{conditionalsd}{ standard deviations for each model }
\item{postmean}{marginal posterior means of each regression coefficient
using BMA} \item{postsd}{marginal posterior standard deviations using BMA}
\item{postne0}{vector of posterior inclusion probabilities, marginal
probability that a coefficient is non-zero}
}
\description{
Extract conditional posterior means and standard deviations, marginal
posterior means and standard deviations, posterior probabilities, and
marginal inclusions probabilities under Bayesian Model Averaging from an
object of class 'bas'

Print coefficients generated from coef.bas
}
\details{
Calculates posterior means and (approximate) standard deviations of the
regression coefficients under Bayesian Model averaging using g-priors and
mixtures of g-priors.  Print returns overall summaries. For fully Bayesian
methods that place a prior on g, the posterior standard deviations do not
take into account full uncertainty regarding g. Will be updated in future
releases.
}
\note{
With highly correlated variables, marginal summaries may not be
representative of the joint distribution. Use \code{\link{plot.coef.bas}} to
view distributions.  The value reported for the intercept is
under the centered parameterization.  Under the  Gaussian error
model it will be centered at the sample mean of Y.
}
\examples{

data("Hald")
hald.gprior =  bas.lm(Y~ ., data=Hald, n.models=2^4, alpha=13,
                      prior="ZS-null", initprobs="Uniform", update=10)
coef.hald.gprior = coefficients(hald.gprior)
coef.hald.gprior
plot(coef.hald.gprior)
confint(coef.hald.gprior)

#Estimation under Median Probability Model
coef.hald.gprior = coefficients(hald.gprior, estimator="MPM")
coef.hald.gprior
plot(coef.hald.gprior)
plot(confint(coef.hald.gprior))


coef.hald.gprior = coefficients(hald.gprior, estimator="HPM")
coef.hald.gprior
plot(coef.hald.gprior)
confint(coef.hald.gprior)

# To add estimation under Best Predictive Model


}
\references{
Liang, F., Paulo, R., Molina, G., Clyde, M. and Berger, J.O.
(2005) Mixtures of g-priors for Bayesian Variable Selection.  Journal of the
American Statistical Association.  103:410-423.  \cr
\url{http://dx.doi.org/10.1198/016214507000001337}
}
\seealso{
\code{\link{bas}}, \code{\link{confint.coef.bas}}

Other bas methods: \code{\link{BAS}}, \code{\link{bas.lm}},
  \code{\link{confint.coef.bas}},
  \code{\link{confint.pred.bas}},
  \code{\link{diagnostics}}, \code{\link{fitted.bas}},
  \code{\link{force.heredity.bas}},
  \code{\link{image.bas}}, \code{\link{predict.basglm}},
  \code{\link{predict.bas}}, \code{\link{summary.bas}},
  \code{\link{update.bas}}
}
\author{
Merlise Clyde \email{clyde@stat.duke.edu}
}
\keyword{regression}
