% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bas.R
\name{print.bas}
\alias{print.bas}
\alias{print}
\title{Print a Summary of Bayesian Model Averaging objects from BAS}
\usage{
\method{print}{bas}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{object of class 'bas'}

\item{digits}{optional number specifying the number of digits to display}

\item{...}{other parameters to be passed to \code{print.default}}
}
\description{
\code{summary} and \code{print} methods for Bayesian model averaging objects
created by \code{bas} Bayesian Adaptive Sampling
}
\details{
The print methods display a view similar to \code{print.lm} .  The summary
methods display a view specific to Bayesian model averaging giving the top 5
highest probability models represented by their inclusion indicators.
Summaries of the models include the Bayes Factor (BF) of each model to the
model with the largest marginal likelihood, the posterior probability of the
models, R2, dim (which includes the intercept) and the log of the marginal
likelihood.
}
\examples{

library(MASS)
data(UScrime)
UScrime[,-2] = log(UScrime[,-2])
crime.bic =  bas.lm(y ~ ., data=UScrime, n.models=2^15, prior="BIC",initprobs= "eplogp")
print(crime.bic)
summary(crime.bic)
}
\seealso{
\code{\link{coef.bas}}
}
\author{
Merlise Clyde \email{clyde@stat.duke.edu}
}
\keyword{print}
\keyword{regression}
