% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{accuracy}
\alias{accuracy}
\title{Scaled mean squared error of accumulation curves.}
\usage{
accuracy(accum, target = -1)
}
\arguments{
\item{accum}{A matrix resulting from the alpha.accum or beta.accum functions (sampling units x diversity values).}

\item{target}{The true known diversity value, with which the curve will be compared. If not specified, default is the diversity observed with all sampling units.}
}
\value{
Accuracy values (both raw and weighted) for all observed and estimated curves.
}
\description{
Accuracy (scaled mean squared error) of accumulation curves compared with a known true diversity value (target).
}
\details{
Among multiple measures of accuracy (Walther & Moore 2005) the SMSE presents several advantages, as it is (Cardoso et al. 2014):
(i) scaled to true diversity, so that similar absolute differences are weighted according to how much they represent of the real value;
(ii) scaled to the number of sampling units, so that values are independent of sample size;
(iii) squared, so that small, mostly meaningless fluctuations around the true value are down-weighted; and
(iv) independent of positive or negative deviation from the real value, as such differentiation is usually not necessary.
For alpha diversity accuracy may also be weighted according to how good the data is predicted to be. The weight of each point in the curve is proportional to its sampling intensity (i.e. n/Sobs).
}
\examples{
comm1 <- matrix(c(2,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,0,2,2), nrow = 4, ncol = 5, byrow = TRUE)
comm2 <- matrix(c(1,1,0,0,0,0,2,1,0,0,0,0,2,1,0,0,0,0,2,1), nrow = 4, ncol = 5, byrow = TRUE)
tree <- hclust(dist(c(1:5), method="euclidean"), method="average")
acc.alpha = alpha.accum(comm1)
accuracy(acc.alpha)
accuracy(acc.alpha, 10)
acc.beta = beta.accum(comm1, comm2, tree)
accuracy(acc.beta)
accuracy(acc.beta, c(1,1,0))
}
\references{
Cardoso, P., Rigal, F., Borges, P.A.V. & Carvalho, J.C. (2014) A new frontier in biodiversity inventory: a proposal for estimators of phylogenetic and functional diversity. Methods in Ecology and Evolution, in press.

Walther, B.A. & Moore, J.L. (2005) The concepts of bias, precision and accuracy, and their use in testing the performance of species richness estimators, with a literature reviewof estimator performance. Ecography, 28, 815-829.
}

