% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{cwe}
\alias{cwe}
\title{Community Weighted Evenness.}
\usage{
cwe(comm, trait, func = "camargo", abund = TRUE)
}
\arguments{
\item{comm}{A sites x species matrix, with incidence or abundance data about the species in the community.}

\item{trait}{A species x traits matrix, with trait values for each species in comm.}

\item{func}{Calculate evenness using Camargo (1993, default) or Bulla (1994) index.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used (TRUE) or converted to incidence (FALSE) before analysis. If not specified, default is TRUE.}
}
\value{
A sites x trait matrix with evenness value per site and trait.
}
\description{
Evenness value of each of a series of traits in multiple communities.
}
\details{
Community weighted evenness is used to compare communities in terms of their evenness of trait values, reflecting trait abundance and distances between values.
}
\examples{
comm <- matrix(c(1,1,1,1,0,1,1,0,0,0,0,1,2,0,0,0,0,0,10,1), nrow = 4, ncol = 5, byrow = TRUE)
rownames(comm) = c("Site1","Site2","Site3","Site4")
colnames(comm) = c("Sp1","Sp2","Sp3","Sp4","Sp5")
trait <- matrix(c(4,1,3,4,2,2,2,1,3,3,2,0,1,4,0,0,5,5,2,1), nrow = 5, ncol = 4, byrow = TRUE)
rownames(trait) = colnames(comm)
colnames(trait) = c("Trait1","Trait2","Trait3","Trait4")
cwe(comm, trait)
cwe(comm, trait, abund = FALSE)
cwe(comm, trait, "bulla")
}
\references{
Bulla, L. (1994) An index of evenness and its associated diversity measure. Oikos, 70: 167-171.

Camargo, J.A. (1993) Must dominance increase with the number of subordinate species in competitive interactions? Journal of Theoretical Biology, 161: 537-542.
}
