% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{optim.alpha}
\alias{optim.alpha}
\title{Optimization of alpha diversity sampling protocols.}
\usage{
optim.alpha(comm, tree, methods, base, seq = FALSE, runs = 1000, prog = TRUE)
}
\arguments{
\item{comm}{A samples x species x sites array, with either abundance or incidence data.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{methods}{A data.frame with the method names (1st column), number of samples per method (2nd column), base cost per method (3rd column, those costs that are fixed once a method is decided), and sample cost per method (those costs that add with each sample of the method, 4th column). If the last two columns are not provided base = 0 and sample = 1. The order of methods must be the same as in comm and the sum of the samples must be the same as nrow(comm).}

\item{base}{A vector defining a base protocol from which to build upon (complementarity analysis) (length must be equal to number of methods).}

\item{seq}{By default all combinations will be tested. If TRUE, a sequential approach will be taken, where methods are added based on the previous step. The method added will be the one providing the highest efficiency as quantified by the slope of the accumulation curve.}

\item{runs}{Number of random permutations to be made to the sample order. Default is 1000.}

\item{prog}{Present a text progress bar in the R console.}
}
\value{
A matrix of samples x methods (values being optimum number of samples per method). The last column is the average alpha diversity value, rescaled to 0-1 if made for several sites, where 1 is the true diversity of each site.
}
\description{
Optimization of alpha diversity sampling protocols when different methods and multiple samples per method are available.
}
\details{
Often a combination of methods allows sampling maximum plot diversity with minimum effort, as it allows sampling different sub-communities, contrary to using single methods.
Cardoso (2009) proposed a way to optimize the number of samples per method when the target is to maximize sampled alpha diversity. It is applied here for TD, PD and FD, and for one or multiple sites simultaneously.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric).
}
\examples{
comm1 <- matrix(c(1,1,0,2,4,0,0,1,2,0,0,3), nrow = 4, ncol = 3, byrow = TRUE)
comm2 <- matrix(c(2,2,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm <- array(c(comm1, comm2), c(4,3,2))
colnames(comm) <- c("Sp1","Sp2","Sp3")

methods <- data.frame(method = c("Met1","Met2","Met3"),
           nSamples = c(1,2,1), fixcost = c(1,1,2), varCost = c(1,1,1))
tree <- hclust(dist(c(1:3), method="euclidean"), method="average")
tree$labels <- colnames(comm)

\dontrun{
  optim.alpha(comm,,methods)
  optim.alpha(comm,,methods, seq = TRUE)
  optim.alpha(comm, tree, methods)
  optim.alpha(comm,, methods = methods, seq = TRUE, base = c(0,1,1))
}
}
\references{
Cardoso, P. (2009) Standardization and optimization of arthropod inventories - the case of Iberian spiders. Biodiversity and Conservation, 18, 3949-3962.
}
