\name{BAwiR-package}
\alias{BAwiR-package}
\docType{package}
\title{
Analysis of Basketball Data
}
\description{
Collection of tools to work with basketball data. Functions available are related to friendly web scraping and visualization. Data were obtained from <http://www.euroleague.net/>, <http://www.eurocupbasketball.com/> and <http://www.acb.com>, following the instructions of their respectives robots.txt files. Tools for visualization include a population pyramid, 2D plots of archetypoids and the rest of players, percentile circular plots, plots to analyze monthly evolution, heatmaps, shooting barplots, four factor plots and maps of players' nationalities.    
}
\details{
\tabular{ll}{
Package: BAwiR\cr
Type: Package\cr
Version: 1.0\cr
Date: 2018-01-25\cr
License: GPL-2\cr
LazyLoad: yes\cr
LazyData: yes\cr
}
acb_games_1718: ACB games 2017-2018.\cr
acb_players_1718: ACB players 2017-2018.\cr
capit_two_words: Capitalize two-word strings.\cr
do_add_adv_stats:	Advanced statistics.\cr
do_EPS: Efficient Points Scored (EPS). \cr
do_four_factors_df:	Four factors data frame.\cr
do_join_games_bio: Join games and players' info.\cr
do_map_nats: Data frame for the nationalities map.\cr
do_OE: Offensive Efficiency (OE). \cr
do_scraping_games: Player game finder data.\cr
do_scraping_rosters: Players profile data.\cr
do_stats: Accumulated or average statistics.\cr
eurocup_games_1718: Eurocup games 2017-2018.\cr
eurocup_players_1718:	Eurocup players 2017-2018.\cr
euroleague_games_1718: Euroleague games 2017-2018.\cr
euroleague_players_1718:	Euroleague players 2017-2018.\cr
get_barplot_monthly_stats: Barplots with monthly stats.\cr
get_bubble_plot: Basketball bubble plot.\cr
get_four_factors_plot: Four factors plot.\cr
get_games_rosters: Get all games and rosters.\cr
get_heatmap_bb: Basketball heatmap.\cr  
get_map_nats: Nationalities map.\cr
get_pop_pyramid_acb: ACB population pyramid.\cr
get_shooting_plot: Shooting plot.\cr
get_similar_players: Similar players to archetypoids.\cr
join_players_bio_age_acb: Join ACB games and players' info.\cr
join_players_bio_age_euro: Join Euroleague and Eurocup games and players' info.\cr
scraping_games_acb: ACB player game finder data.\cr
scraping_games_euro: Euroleague and Eurocup player game finder data.\cr
scraping_rosters_acb: ACB players' profile.\cr
scraping_rosters_euro: Euroleague and Eurocup players' profile.\cr
}
\references{
Vinue, G., (2018). A Web Application for the Visualization of Basketball Data Using R. 
\emph{Submitted}, http://bayes2.ucd.ie:3838/gvinue/AppEuroACB/
}
\author{
Guillermo Vinue <Guillermo.Vinue@uv.es>
}
\keyword{BAwiR}