#' Surface and Interior Faults in 100 Lenses
#'
#' This dataset records counts of surface faults (\eqn{X}) and interior faults (\eqn{Y}) observed in 100 optical lenses
#'
#' @format A data frame with 100 rows and 2 variables:
#' \describe{
#'   \item{X}{Number of surface faults in a lens.}
#'   \item{Y}{Number of interior faults in the same lens.}
#' }
#'
#'
#' @references
#' Aitchison, J., & Ho, C. H. (1989). The multivariate Poisson-log normal distribution. \emph{Biometrika}, 76(4), 643–653. \cr
#' Ghosh, I., Marques, F., & Chakraborty, S. (2021). A new bivariate Poisson distribution via conditional specification: properties and applications. \emph{Journal of Applied Statistics}, 48(16), 3025-3047. \doi{10.1080/02664763.2020.1793307}
"lensfaults"

