% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbinomBCD.R
\name{rbinomBCD}
\alias{rbinomBCD}
\title{Random Sampling from a Bivariate Binomial Distribution via Conditional Specification}
\usage{
rbinomBCD(n, n1, n2, p1, p2, lambda, seed = 123, verbose = TRUE)
}
\arguments{
\item{n}{number of samples to generate.}

\item{n1}{number of trials for \eqn{ X }, must be non-negative.}

\item{n2}{number of trials for \eqn{ Y }, must be non-negative.}

\item{p1}{base success probability for \eqn{ X }, in (0, 1).}

\item{p2}{base success probability for \eqn{ Y }, in (0, 1).}

\item{lambda}{dependence parameter, must be positive.}

\item{seed}{seed for random number generation (default = 123).}

\item{verbose}{logical; if TRUE (default), prints progress updates and a summary.}
}
\value{
A data frame with columns `X` and `Y`, containing the sampled values.
}
\description{
Generates random samples from a bivariate binomial conditionals distribution (BBCD).
}
\examples{
samples <- rbinomBCD(n = 100, n1 = 10, n2 = 10, p1 = 0.5, p2 = 0.4, lambda = 1.2)
head(samples)

}
