% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGData.R
\name{as.BGData}
\alias{as.BGData}
\alias{as.BGData.BEDMatrix}
\alias{as.BGData.ColumnLinkedMatrix}
\alias{as.BGData.RowLinkedMatrix}
\title{Convert Other Objects to BGData Objects.}
\usage{
as.BGData(x, alternatePhenotypeFile = NULL, ...)

\method{as.BGData}{BEDMatrix}(x, alternatePhenotypeFile = NULL, ...)

\method{as.BGData}{ColumnLinkedMatrix}(x, alternatePhenotypeFile = NULL, ...)

\method{as.BGData}{RowLinkedMatrix}(x, alternatePhenotypeFile = NULL, ...)
}
\arguments{
\item{x}{An object. Currently supported are \link[BEDMatrix:BEDMatrix-class]{BEDMatrix::BEDMatrix}
objects, plain or nested in \link[LinkedMatrix:ColumnLinkedMatrix-class]{LinkedMatrix::ColumnLinkedMatrix}
objects.}

\item{alternatePhenotypeFile}{Path to an \href{https://www.cog-genomics.org/plink2/input#pheno}{alternate phenotypefile}.}

\item{...}{Additional arguments to the \code{\link[utils:read.table]{utils::read.table()}} or
\code{\link[data.table:fread]{data.table::fread()}} call (if data.table package is installed) call to
parse the alternate pheno file.}
}
\value{
A \linkS4class{BGData} object.
}
\description{
Converts other objects to \linkS4class{BGData} objects by loading supplementary
phenotypes and map files referenced by the object to be used for the
\code{@pheno} and \code{@map} slot, respectively. Currently supported are
\link[BEDMatrix:BEDMatrix-class]{BEDMatrix::BEDMatrix} objects, plain or nested in
\link[LinkedMatrix:ColumnLinkedMatrix-class]{LinkedMatrix::ColumnLinkedMatrix} objects.
}
\details{
The .ped and .raw formats only allows for a single phenotype. If more
phenotypes are required it is possible to store them in an \href{https://www.cog-genomics.org/plink2/input#pheno}{alternatephenotype file}. The path
to such a file can be provided with \code{alternatePhenotypeFile} and will be
merged with the data in the \code{@pheno} slot.

For \link[BEDMatrix:BEDMatrix-class]{BEDMatrix::BEDMatrix} objects: If a .fam file (which corresponds
to the first six columns of a .ped or .raw file) of the same name and in the
same directory as the BED file exists, the \code{@pheno} slot will be populated
with the data stored in that file. Otherwise a stub that only contains an
\code{IID} column populated with the rownames of \code{@geno} will be generated. The
same will happen for a .bim file for the \code{@map} slot.

For \link[LinkedMatrix:ColumnLinkedMatrix-class]{LinkedMatrix::ColumnLinkedMatrix} objects: See the case for
\link[BEDMatrix:BEDMatrix-class]{BEDMatrix::BEDMatrix} objects, but only the .fam file of the first
node of the \link[LinkedMatrix:LinkedMatrix-class]{LinkedMatrix::LinkedMatrix} will be read and used for the
\code{@pheno} slot, and the .bim files of all nodes will be combined and used
for the \code{@map} slot.
}
\examples{
# Path to example data
path <- system.file("extdata", package = "BGData")

# Convert a single BEDMatrix object to a BGData object
chr1 <- BEDMatrix::BEDMatrix(paste0(path, "/chr1.bed"))
bg1 <- as.BGData(chr1)

# Convert multiple BEDMatrix objects in a ColumnLinkedMatrix to a BGData object
chr2 <- BEDMatrix::BEDMatrix(paste0(path, "/chr2.bed"))
chr3 <- BEDMatrix::BEDMatrix(paste0(path, "/chr3.bed"))
clm <- ColumnLinkedMatrix(chr1, chr2, chr3)
bg2 <- as.BGData(clm)

# Load additional (alternate) phenotypes
bg3 <- as.BGData(clm, alternatePhenotypeFile = paste0(path, "/pheno.txt"))
}
\seealso{
\code{\link[=readRAW]{readRAW()}} to convert text files to \linkS4class{BGData} objects.
}
