% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BePloth.R
\name{BePloth}
\alias{BePloth}
\title{Plots for the discrete Hazard and Survival Function Estimates}
\usage{
BePloth(
  M,
  type.h = "dot",
  add.survival = T,
  intervals = T,
  confidence = 0.95,
  summary = FALSE
)
}
\arguments{
\item{M}{tibble. Contains the output generated by \code{BeMRres}.}

\item{type.h}{character, "line" = plots the hazard rate of each interval
joined by a line, "dot" = plots the hazard rate of each interval with a dot.}

\item{add.survival}{logical, If \code{TRUE}, plots the Nelson-Alen based
estimate in the same graphic of the hazard rate and the Kaplan-Meier
estimates of the survival function.}

\item{intervals}{logical. If TRUE, plots confidence bands for the selected functions including Nelson-Aalen and/or Kaplan-Meier estimate.}

\item{confidence}{Numeric. Confidence band width.}

\item{summary}{Logical. If \code{TRUE}, a summary for hazard and survival
functions is returned as a tibble.}
}
\value{
\item{SUM.h}{Numeric tibble. Summary for the mean, median, and a
\code{confint / 100} confidence interval for each failure time of the hazard
function.} \item{SUM.S}{Numeric tibble. Summary for the mean, median, and a
\code{confint / 100} confidence interval for each failure time of the survival
function.}
}
\description{
Plots the resulting hazard function along with the survival function
estimates defined by the Markov beta process (Nieto-Barajas and Walker,
2002).
}
\details{
This function returns estimators plots for the hazard rate as computed
by \code{\link{BeMRes}} together with the Nelson-Aalen estimate along with their
confidence intervals for the data set given. Additionally, it plots the
survival function and the Kaplan-Meier estimate with their corresponding
credible intervals.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
#  data(psych)
#  timesP <- psych$time
#  deltaP <- psych$death
#  BEX1 <- BeMRes(timesP, deltaP, iterations = 3000, burn.in = 300, thinning = 1)
#  BePloth(BEX1)
#  sum <- BePloth(BEX1, type.h = "line", summary = T)

## Example 2
#  data(gehan)
#  timesG <- gehan$time[gehan$treat == "control"]
#  deltaG <- gehan$cens[gehan$treat == "control"]
#  BEX2 <- BeMRes(timesG, deltaG, type.c = 2, c.r = rep(50, 22))
#  BePloth(BEX2)



}
\references{
- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and
gamma processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{BeMRes}, \link{BePlotDiag}
}
