% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{rmse}
\alias{rmse}
\alias{rmse.bgvar.pred}
\title{Compute Root Mean Squared Errors}
\usage{
\method{rmse}{bgvar.pred}(object, ...)
}
\arguments{
\item{object}{an object of class \code{bgvar.predict}.}

\item{...}{additional arguments.}
}
\value{
Returns an object of class \code{bgvar.rmse}, which is a matrix of dimension h times K, whereas h is the forecasting horizon and K is the number of variables in the system.
}
\description{
Computes and prints root mean squared errors (RMSEs) of an object of class \code{bgvar.predict}.
}
\examples{
library(BGVAR)
data(eerDatasmall)
model.ssvs.eer<-bgvar(Data=eerDatasmall,W=W.trade0012.small,draws=100,burnin=100,
                      plag=1,prior="SSVS",eigen=TRUE,h=8)
fcast <- predict(model.ssvs.eer,n.ahead=8,save.store=TRUE)
rmse <- rmse(fcast)
}
\author{
Maximilian Boeck, Martin Feldkircher
}
