
<!-- README.md is generated from README.Rmd. Please edit that file -->

# BGmisc

<!-- badges: start -->

[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![R package
version](https://www.r-pkg.org/badges/version/BGmisc)](https://cran.r-project.org/package=BGmisc)
[![Package
downloads](https://cranlogs.r-pkg.org/badges/grand-total/BGmisc)](https://cran.r-project.org/package=BGmisc)</br>
[![status](https://joss.theoj.org/papers/ee3a025be4f61584f977a7657d936187/status.svg)](https://joss.theoj.org/papers/10.21105/joss.06203)

[![R-CMD-check](https://github.com/R-Computing-Lab/BGmisc/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/R-Computing-Lab/BGmisc/actions/workflows/R-CMD-check.yaml)
[![Dev Main
branch](https://github.com/R-Computing-Lab/BGmisc/actions/workflows/R-CMD-dev_maincheck.yaml/badge.svg)](https://github.com/R-Computing-Lab/BGmisc/actions/workflows/R-CMD-dev_maincheck.yaml)
![License](https://img.shields.io/badge/License-GPL_v3-blue.svg)
<!-- badges: end -->

The BGmisc R package offers a comprehensive suite of functions tailored
for extended behavior genetics analysis, including model identification,
calculating relatedness, pedigree conversion, pedigree simulation, and
more.

## Installation

You can install the released version of BGmisc from
[CRAN](https://cran.r-project.org/) with:

``` r
install.packages("BGmisc")
```

To install the development version of BGmisc from
[GitHub](https://github.com/) use:

``` r
# install.packages("devtools")
devtools::install_github("R-Computing-Lab/BGmisc")
```

## Citation

If you use BGmisc in your research or wish to refer to it, please cite
the following paper:

    citation(package = "BGmisc")

Garrison, S. Mason, Hunter, Michael D., Lyu, Xuanyu, Trattner, Jonathan
D., Burt, S. Alexandra (2024). “BGmisc: An R Package for Extended
Behavior Genetics Analysis.” *Journal of Open Source Software*, *9*(94).
<doi:10.21105/joss.06203> <https://doi.org/10.21105/joss.06203>.

A BibTeX entry for LaTeX users is

    @Article{bgmisc,
      title = {BGmisc: An R Package for Extended Behavior Genetics Analysis},
      author = {{Garrison, S. Mason} and {Hunter, Michael D.} and {Lyu, Xuanyu} and {Trattner, Jonathan D.} and {Burt, S. Alexandra}},
      journal = {Journal of Open Source Software},
      year = {2024},
      volume = {9},
      number = {94},
      doi = {10.21105/joss.06203},
    }

## Contributing

Contributions to the BGmisc project are welcome. For guidelines on how
to contribute, please refer to the [Contributing
Guidelines](https://github.com/R-Computing-Lab/BGmisc/blob/main/CONTRIBUTING.md).
Issues and pull requests should be submitted on the GitHub repository.
For support, please use the GitHub issues page.

## License

BGmisc is licensed under the GNU General Public License v3.0. For more
details, see the
[LICENSE.md](https://github.com/R-Computing-Lab/BGmisc/blob/main/LICENSE.md)
file.
