% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_species}
\alias{BIEN_ranges_species}
\title{Download range maps for given species.}
\usage{
BIEN_ranges_species(species, directory = NULL, matched = TRUE,
  match_names_only = FALSE, include.gid = FALSE, ...)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{matched}{Return a list of taxa that were downloaded. Default is TRUE.}

\item{match_names_only}{Check for range maps for the taxa specified without downloading range maps. Default is FALSE.}

\item{include.gid}{Should the files returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Range maps for specified species.
}
\description{
BIEN_ranges_species extracts range maps for the specified species.
}
\note{
Details on the construction of BIEN range maps is available at http://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\dontrun{
library(rgdal)
library(maps) #a convenient source of maps
species_vector<-c("Abies_lasiocarpa","Abies_amabilis")
BIEN_ranges_species(species_vector)
BIEN_ranges_species(species_vector,match_names_only = TRUE)
temp_dir <- file.path(tempdir(), "BIEN_temp")#Set a working directory
BIEN_ranges_species(species_vector,temp_dir)#saves ranges to a temporary directory
BIEN_ranges_species("Abies_lasiocarpa")
BIEN_ranges_species("Abies_lasiocarpa",temp_dir)

#Reading files

Abies_poly<-readOGR(dsn = temp_dir,layer = "Abies_lasiocarpa")

#Plotting files
plot(Abies_poly)#plots the range, but doesn't mean much without any reference
map('world', fill = TRUE, col = "grey")#plots a world map (WGS84 projection), in grey
plot(Abies_poly,col="forest green",add=TRUE) #adds the range of Abies lasiocarpa to the map

#Getting data from the files (currently only species names)
Abies_poly$Species#gives the species name associated with "Abies_poly"}
}
\seealso{
Other range functions: \code{\link{BIEN_ranges_box}},
  \code{\link{BIEN_ranges_genus}},
  \code{\link{BIEN_ranges_intersect_species}},
  \code{\link{BIEN_ranges_list}},
  \code{\link{BIEN_ranges_load_species}},
  \code{\link{BIEN_ranges_spatialpolygons}}
}
