% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctCoordGPS.R
\name{correctCoordGPS}
\alias{correctCoordGPS}
\title{Correct the GPS coordinates}
\usage{
correctCoordGPS(longlat = NULL, projCoord = NULL, coordRel, rangeX,
  rangeY, maxDist = 10, drawPlot = FALSE, rmOutliers = FALSE)
}
\arguments{
\item{longlat}{(optionnal) data frame with the coordinate in longitude latitude (eg. cbind(longitude, latitude)).}

\item{projCoord}{(optionnal) data frame with the projected coordinate in X Y}

\item{coordRel}{data frame with the relative coordinate in the same order than the longlat or projCoord}

\item{rangeX}{a vector of length 2 giving the range for plot relative X coordinates}

\item{rangeY}{a vector of length 2 giving the range for plot relative Y coordinates}

\item{maxDist}{a numeric giving the maximum distance above which GPS measurements should be considered as outliers (by default 10 m)}

\item{drawPlot}{a logical if you want to display a graphical representation}

\item{rmOutliers}{a logical if you want to remove the outliers from coordinates calculation}
}
\value{
If you there are no outliers or rmOutliers = TRUE, a list with:
\itemize{
\item \code{corner}: a matrix with the coordinates of the corners
\item \code{polygon}: a spatial polygon
\item \code{outliers}: Coordinates lines considered as outliers, if any
}
}
\description{
This function build the most probable GPS coordinates of the plot corners from multiple GPS measurements.
}
\details{
You must give one parameter between longlat and projCoord
}
\examples{
projCoord <- data.frame(
  X = c(
    runif(5, min = 9, max = 11), runif(5, min = 8, max = 12),
    runif(5, min = 80, max = 120), runif(5, min = 90, max = 110)
  ),
  Y = c(
    runif(5, min = 9, max = 11), runif(5, min = 80, max = 120),
    runif(5, min = 8, max = 12), runif(5, min = 90, max = 110)
  )
)
projCoord <- projCoord + 1000
coordRel <- data.frame(
  X = c(rep(0, 10), rep(100, 10)),
  Y = c(rep(c(rep(0, 5), rep(100, 5)), 2))
)

aa <- correctCoordGPS(
  projCoord = projCoord, coordRel = coordRel,
  rangeX = c(0, 100), rangeY = c(0, 100)
)
bb <- correctCoordGPS(
  projCoord = projCoord, coordRel = coordRel,
  rangeX = c(0, 100), rangeY = c(0, 100), rmOutliers = TRUE
)
\dontrun{
correctCoordGPS(
  projCoord = projCoord, coordRel = coordRel,
  rangeX = c(0, 100), rangeY = c(0, 100), drawPlot = TRUE
)
}

}
\author{
Arthur PERE, Maxime REJOU-MECHAIN

Arthur PERE, Maxime REJOU-MECHAIN
}
