\name{MCpriorIntFun.nl}
\alias{MCpriorIntFun.nl}
\alias{MCpriorIntFun.pb}
\title{Generic Monte-Carlo integration  under the prior distribution in the PB and NL  models.}
\usage{
  MCpriorIntFun.nl(Nsim = 200, FUN = function(par, ...) {
        par }, store = TRUE, Hpar = get("nl.Hpar"),
    show.progress = floor(seq(1, Nsim, length.out = 20)),
    Nsim.min = Nsim, precision = 0, ...)

  MCpriorIntFun.pb(Nsim = 200, Hpar = get("pb.Hpar"),
    dimData = 3, FUN = function(par, ...) {
        as.vector(par) }, store = TRUE,
    show.progress = floor(seq(1, Nsim, length.out = 20)),
    Nsim.min = Nsim, precision = 0, ...)
}
\arguments{
  \item{Hpar}{Hyper-parameters for the PB prior (in
  \code{MCpriorIntFun.pb}) or the NL prior
  (\code{MCpriorIntFun.nl}). See \code{\link{pb.Hpar}} and
  \code{\link{nl.Hpar}} for the required formats.}

  \item{dimData}{Only for the PB model: The dimension of
  model's \emph{sample} space. The PB parameter space is of
  dimension \code{choose(dimData,2)+1}. The NL model
  implemented here is restricted to three-dimensional
  sample spaces.}

  \item{Nsim}{Maximum number of iterations}

  \item{FUN}{A function to be integrated. It may return a
  vector or an array.}

  \item{store}{Should the successive evaluations of
  \code{FUN} be stored ?}

  \item{show.progress}{same as in
  \code{\link{posteriorMCMC}}}

  \item{Nsim.min}{The minimum number of iterations to be
  performed.}

  \item{precision}{The desired relative precision
  \eqn{\epsilon}. See \bold{Details} below.}

  \item{...}{Additional arguments to be passed to
  \code{FUN}.}
}
\value{
  The list returned by function
  \code{\link{MCpriorIntFun}}.
}
\description{
  Wrappers for \code{\link{MCpriorIntFun}} with argument
  \code{prior=prior.pb} or \code{prior=prior.nl}
}
\seealso{
  \code{\link{MCpriorIntFun}}
}

