% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{plot.BMhybResult}
\alias{plot.BMhybResult}
\title{Plot BMhyb result}
\usage{
\method{plot}{BMhybResult}(x, style = "univariate",
  focal.color = "red", inregion.color = "black",
  outregion.color = "gray", gradientworst.color = "black",
  gradientbest.color = "white", contour.color = "red",
  contour.threshold = 2, nrow = NULL, ...)
}
\arguments{
\item{x}{A BMhyb object (result of a BMhyb() call)}

\item{style}{Either univariate or contour}

\item{focal.color}{Color for the point showing the maximum likelihood estimate}

\item{inregion.color}{Color for univariate plot, points in the good region}

\item{outregion.color}{Color for univariate plot, points in the bad region}

\item{gradientworst.color}{Color for contour plot, color of the worst contour region}

\item{gradientbest.color}{Color for contour plot, color of the best contour region}

\item{contour.color}{Color showing the contour line for the best threshold}

\item{contour.threshold}{What delta log likelihood to use for the best/worst threshold for the contour plot}

\item{nrow}{The number of rows to plot in the grid for contour (will set it automatically if NULL)}

\item{...}{Other arguments to pass to plot (for univariate only; the contour plot uses ggplot2)}
}
\description{
Shows the plot of confidence regions with MLEs indicated (red dots) or a plot of pairs of traits together. Note that for the latter plot, it converts the sampled points to an even grid with interpolation; it sets any points with likelihood worse than ten units to just ten units worse so that you can see the colors near the area of the optimum.
}
