% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{BMhyb}
\alias{BMhyb}
\title{Optimize model}
\usage{
BMhyb(phy.graph, traits, free.parameter.names = c("sigma.sq", "mu", "SE",
  "bt", "vh"), confidence.points = 5000, measurement.error = 0,
  gamma = 0.5, do.Higham.correction = FALSE,
  do.Brissette.correction = FALSE, verbose = TRUE,
  likelihood.precision = 0.01, max.steps = 10, confidence.lnl = 2,
  control = list(reltol = 0.001))
}
\arguments{
\item{phy.graph}{An ape::evonet object (a phylogeny stored in phylo format that also includes a reticulation matrix)}

\item{traits}{A vector of trait values, with names equal to the names of taxa on the phylogeny}

\item{free.parameter.names}{What parameters you want to optimize rather than use defaults; options are sigma.sq, mu, SE, bt, and vh}

\item{confidence.points}{How many points to use to estimate parameter uncertainty}

\item{measurement.error}{How much uncertainty there is in tip values; a single number is applied to all taxa, a vector is applied to the corresponding taxa}

\item{gamma}{In a hybridization event, what proportion of the trait comes from the donating parent. 0.5 means half comes from each parent}

\item{do.Higham.correction}{Variance-covariance matrices for this model are sometimes poorly conditioned; this is a hack to reduce the impact of that}

\item{do.Brissette.correction}{Applies method of Brissette et al. 2007 to also try to fix matrix condition}

\item{verbose}{If TRUE, BMhyb will chat about its progress}

\item{likelihood.precision}{When optimizing, how much of a lnL improvement is required to restart optimization between starts}

\item{max.steps}{The number of restarts without improvement it will attempt}

\item{confidence.lnl}{For figuring out the confidence interval, how wide you want the confidence region to be in lnL space}

\item{control}{List of options to pass to optim. ?optim for help.}
}
\value{
Returns an object of class BMhybResult which contains best (a data.frame of the solution), good.region (data.frame of the points making up those in the confidence.lnl region), bad.region (all the other points sampled), phy.graph (same as what you put in), traits (same as what you put in), and free.parameter.names.
}
\description{
Fits a BMhyb model to your data.
}
\details{
This takes an ape::evonet object. If all you have is a tree (an ape::phylo object), you can use CreateHybridlessEvonet() to convert the tree to an evonet object. You can then use the AddHybridization() function to add hybrid events to this object. Note that networks created in this way can, by chance, result in orders of nodes in the internal edge matrix that cause ape's reorder.phylo function to crash, which is called in many of the plot and write functions. You can still use the plot functions in this package, however.
}
\examples{
\dontrun{
utils::data("cichlid")
result <- BMhyb(phy.graph=cichlid$phy.graph, traits=cichlid$trait,
  free.parameter.names=c("sigma.sq", "mu"))
}
}
