% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{ComputeVCV}
\alias{ComputeVCV}
\title{Compute the variance-covariance matrix}
\usage{
ComputeVCV(phy.graph, sigma.sq = 1, mu = 0, bt = 1, vh = 0,
  SE = 0, measurement.error = 0, gamma = 0.5)
}
\arguments{
\item{phy.graph}{An ape::evonet object (a phylogeny stored in phylo format that also includes a reticulation matrix)}

\item{sigma.sq}{Value for sigma squared}

\item{mu}{Value for state at the root}

\item{bt}{Value for beta parameter}

\item{vh}{Value for Vh, the variance that comes from a hybridization event}

\item{SE}{Standard error}

\item{measurement.error}{How much uncertainty there is in tip values; a single number is applied to all taxa, a vector is applied to the corresponding taxa}

\item{gamma}{In a hybridization event, what proportion of the trait comes from the donating parent. 0.5 means half comes from each parent}
}
\value{
Returns the variance-covariance matrix
}
\description{
Creates a variance-covariance matrix for a network and parameters.
}
