\name{AdaptiveConfidenceIntervalSampling}
\alias{AdaptiveConfidenceIntervalSampling}
\title{
Confidence interval under adaptive cluster sampling technique
}
\description{
This function uses adaptive cluster sampling technique to generate confidence interval for parameters of interest.
}

\usage{
AdaptiveConfidenceIntervalSampling(par, fn, lower=-Inf, upper=Inf, desired.delta = 2, 
n.points=5000, verbose=TRUE, ...)
}

\arguments{
  \item{par}{parameter of interest for sampling in the model.}
  \item{fn}{the negative log-likelihood function.}
  \item{lower}{the lower bound for the values allowed for sampling.} 
  \item{upper}{the upper bound for the values allowed for sampling.}
  \item{desired.delta}{a numeric value with a default value of 2 for the criterions that the desired log-likelihood shall no more than 2 unit away from the maximum.}
  \item{n.points}{number of required points for calculating likeilihood value.}
  \item{verbose}{whether to print detailed information during the run.}
  \item{...}{further arguments passed(see details).}
}
\details{
This function starts with a given parameters values, then the points are generated by the function \code{GeneratedValues} and the likelihood value is calculated and sotred. To ensure the sampling is widely enough, we restrict the width.ratio (defined by the ratio of the sampled ranged over the total range of the points) to be less than 0.5.  The default number of simulated point is set to 5000 and the desired intervals are determined with the end points that within the value of \emph{desired.detla}. For the further argument passed, users shall specify the tree in phylo class, the structure of gene flow, the desired parameters for generated values, and whether is allow the extrapolation when the likelihood function is difficult to calculate.
} 

\value{
 a data frame where the first column contains the calculated likelihood values and the rest of columns are the grid points of the parameters generated under the adaptive sampling technique.
 }

\author{
	Brian O'Meara, Dwueng-Chwuan Jhwueng. 
	}

\references{
	Jhwueng D.C. and O'Meara B.C. 2014. \emph{Studying trait evolution in hybrid species on phylogenetic networks}. Submitted. 
	
	Seber G.A.F., Salehi M.M.  2013. Adaptive sampling designs: Inference for spatial and clustered population.  Springer.
	}

\examples{
	library(corpcor)	
	#assign the number of non hybrid taxa 
	ntax.nonhybrid<-4
	#assign the number of hybrid
	ntax.hybrid<-1
	#simulate the network
	network<-SimulateNetwork(ntax.nonhybrid=ntax.nonhybrid, ntax.hybrid=ntax.hybrid, 
	flow.proportion=0.5, origin.type='clade', birth = 1, death = 0.5, sample.f = 0.5, 
	tree.height = 1, allow.ghost=FALSE)
	
	#generate the tip data
	tips<-rnorm(ntax.nonhybrid+ntax.hybrid)
	names(tips)<-paste("t",(1:(ntax.nonhybrid+ntax.hybrid)),sep="")
	
	#set free parameters	
	free.parameters<-rep(TRUE, 5)
	names(free.parameters) <- c("sigma.sq", "mu", "bt", "vh", "SE")
	
	#the best parameter values for the confidence intevals
	par<-c(0.01,1,1,0,0)

	#Simulate 100 samples  
	interval.results <- AdaptiveConfidenceIntervalSampling(par, fn=CalculateLikelihood, 
	lower=c(0, -Inf, 0, 0, 0)[which(free.parameters)], n.points=100,data=tips, 
	phy=network$phy, flow=network$flow, actual.params =
	free.parameters[which(free.parameters)], allow.extrapolation=TRUE)
    
    #show the results
	interval.results.in <- interval.results[which(interval.results[,1] - 
	min(interval.results[,1])<=2),]
	interval.results.out <- interval.results[which(interval.results[,1] - 
	min(interval.results[,1])>2),]	
	interval.results.in
	interval.results.out	
	}