% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cSLI_mv}
\alias{cSLI_mv}
\title{C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler}
\arguments{
\item{data}{a matrix of observations}

\item{grid}{matrix of points to evaluate the density}

\item{niter}{number of iterations}

\item{nburn}{number of burn-in iterations}

\item{m0}{expectation of location component}

\item{k0}{tuning parameter of variance of location component}

\item{S0}{parameter of scale component}

\item{n0}{parameter of scale component}

\item{mass}{mass of Dirichlet process}

\item{nupd}{number of iterations to show current updating}

\item{out_param}{if TRUE, return also the location and scale paramteres lists}

\item{out_dens}{if TRUE, return also the estimated density (default TRUE)}

\item{sigma_PY}{second parameter of PY}

\item{print_message}{print the status}

\item{light_dens}{if TRUE return only the posterior mean of the density}
}
\description{
C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler
}
\examples{
{
  data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
                  c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
  grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
                    seq(-7, 7, length.out = 50)))
  est_model <- cSLI_mv(data_toy, grid, 20, 10, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
  \dontshow{
    data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
                  c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
    grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
                    seq(-7, 7, length.out = 50)))
    est_model <- cSLI_mv(data_toy, grid, 20, 10, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
  }
  \donttest{
    data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
                  c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
    grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
                    seq(-7, 7, length.out = 50)))
    est_model <- cSLI_mv(data_toy, grid, 1000, 100, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
  }
}

}
