% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDPdensity.R
\name{DDPdensity}
\alias{DDPdensity}
\title{MCMC for GM-dependent Dirichlet process mixtures of Gaussians}
\usage{
DDPdensity(y, group, mcmc = list(), prior = list(), output = list())
}
\arguments{
\item{y}{a vector or matrix giving the data based on which densities are to be estimated;}

\item{group}{vector of length \code{length(y)} containing the group labels (integers)
for the elements of \code{y};}

\item{mcmc}{list of MCMC arguments:
\itemize{
\item \code{niter}  (mandatory), number of iterations.

\item \code{nburn}  (mandatory),  number of iterations to discard as burn-in.

  \item \code{nupd}, argument controlling the number of iterations to be displayed on screen: the function reports
  on standard output every time \code{nupd} new iterations have been carried out (default is \code{niter/10}).

  \item \code{print_message}, control option. If equal to \code{TRUE}, the status is printed
  to standard output every \code{nupd} iterations (default is \code{TRUE}).

  \item \code{m_imp}, number of generated values for the importance sampling step of the
  importance conditional sampler (default is 10). See \code{details}.

}}

\item{prior}{a list giving the prior information, which contains:

\itemize{
\item \code{strength}, the strength parameter, or total mass, of the marginal Dirichlet processes (default 1);
\item \code{m0}, mean of the normal base measure on the location parameter (default 0);
\item \code{k0}, scale factor appearing in the normal base measure on the location parameter (default 1);
\item \code{a0}, shape parameter of the inverse gamma base measure on the scale parameter (default 2);
\item \code{b0}, scale parameter of the inverse gamma base measure on the scale parameter (default 1);
\item \code{wei}, parameter controlling the strength of dependence across Dirichlet processes (default 1/2).
}}

\item{output}{a list of arguments for generating posterior output. It contains:

\itemize{
\item \code{grid}, a grid of points at which to evaluate the estimated posterior mean densities (common for all the groups).
\item \code{out_type}, if \code{out_type = "FULL"}, return the estimated partitions and the realizations of the posterior density for each iterations. If \code{out_type = "MEAN"}, return
the estimated partitions and the mean of the densities sampled at each iterations. If \code{out_type = "CLUST"}, return the estimated partitions. Default \code{out_type = "FULL"}.
}}
}
\value{
A \code{BNPdensity} class object containing the estimated densities for each iteration,
the allocations for each iteration; the grid used to evaluate the densities (for each group); the
densities sampled from the posterior distribution (for each group); the groups; the weights of the processes.
The function returns also informations regarding the estimation: the number of iterations, the number
of burn-in iterations and the execution time.
}
\description{
The \code{DDPdensity} function generates posterior density samples for a univariate Griffiths-Milne dependent Dirichlet process mixture model with Gaussian
kernel, for partially exchangeable data. The function implements the importance conditional sampler method.
}
\details{
This function fits a Griffiths-Milne dependent Dirichlet process (GM-DDP) mixture
for density estimation for partially exchangeable data (Lijoi et al., 2014).
For each observation the \code{group} variable allows the observations to be gathered
into \eqn{L}=\code{length(unique(group))} distinct groups.
The model assumes exchangeability within each group, with observations in the \eqn{l}th group marginally
modelled by a location-scale Dirichlet process mixtures, i.e.
\deqn{\tilde f_l(y) = \int \phi(y; \mu, \sigma^2) \tilde p_l (d \mu, d \sigma^2)}
where each \eqn{\tilde p_l} is a Dirichlet process with total mass \code{strength} and base measure \eqn{P_0}.
The vector \eqn{\tilde p = (\tilde p_1,\ldots,\tilde p_L)} is assumed to be jointly distributed as a vector of
GM-DDP(\code{strength}, \code{wei};  \eqn{P_0}), where \code{strength} and
\eqn{P_0} are the total mass parameter and the base measure of each \eqn{\tilde p_l}, and \code{wei}
controls the dependence across the components of
\eqn{\tilde p}. Admissible values for \code{wei} are in \eqn{(0,1)}, with the two extremes of the range
corresponding to full exchangeability (\code{wei}\eqn{\rightarrow 0})
 and  independence across groups (\code{wei}\eqn{\rightarrow 1}).

 \eqn{P_0} is a normal-inverse gamma base measure, i.e.
  \deqn{P_0(d\mu,d\sigma^2) = N(d \mu; m_0, \sigma^2 / k_0) \times IGa(d \sigma^2; a_0, b_0).}{%
      P_0 (d\mu,d\sigma^2) = N(d \mu; m0, \sigma^2 / k0)  IGa(d \sigma^2; a0, b0).}

Posterior sampling is obtained by implementing the importance conditional sampler (Canale et al., 2019).
}
\examples{
data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
group_toy <- c(rep(1,100), rep(2,100))
grid <- seq(-7, 7, length.out = 50)
est_model <- DDPdensity(y = data_toy, group = group_toy,
mcmc = list(niter = 200, nburn = 100, napprox_unif = 50),
output = list(grid = grid))
summary(est_model)
plot(est_model)

}
\references{
Lijoi, A., Nipoti, B., and Pruenster, I. (2014). Bayesian inference with
dependent normalized completely random measures. Bernoulli 20, 1260–1291.

Canale, A., Corradin, R., & Nipoti, B. (2019). Importance conditional sampling for
 Bayesian nonparametric mixtures. arXiv preprint arXiv:1906.08147.
}
