% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{partition.BNPdens}
\alias{partition.BNPdens}
\title{Estimate the partition of the data}
\usage{
\method{partition}{BNPdens}(object, dist = "VI", max_k = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{BNPdens};}

\item{dist}{a loss function defined on the space of partitions;
it can be variation of information  (\code{"VI"}) or \code{"Binder"}, default \code{"VI"}. See details;}

\item{max_k}{maximum number of clusters passed to the \code{cutree} function. See value below;}

\item{...}{additional arguments to be passed.}
}
\value{
The method returns a list containing a matrix with \code{nrow(data)} columns and 3 rows. Each row reports
the cluster labels for each observation according to three different approaches, one per row. The first and second rows
are the output of an agglomerative clustering procedure obtained by applying the function \code{hclust}
to the dissimilarity matrix, and by using the complete or average linkage,
respectively. The number of clusters is between 1 and \code{max_k} and is choosen according to a lower bound
on the expected loss, as described in Wade and Ghahramani (2018).
The third row reports the partition visited by the MCMC with the minimum distance \code{dist} from the dissimilarity matrix.

In addition, the list reports a vector with three scores representing the lower bound on the expected loss
for the three partitions.
}
\description{
The \code{partition} method estimates the partition of the data based on the output generated by a Bayesian nonparametric mixture
model, according to a specified criterion, for a \code{BNPdens} class object.
}
\details{
This method returns point estimates for the clustering of the data induced by a nonparametric mixture model.
This result is achieved exploiting two different loss fuctions on the space of partitions: variation of information
 (\code{dist = 'VI'}) and Binder's loss (\code{dist = 'Binder'}). The function is based on the \code{mcclust.ext}
code by Sara Wade (Wade and Ghahramani, 2018).
}
\examples{
data_toy <- c(rnorm(10, -3, 1), rnorm(10, 3, 1))
grid <- seq(-7, 7, length.out = 50)
fit <- PYdensity(y = data_toy, mcmc = list(niter = 100,
                      nburn = 10, nupd = 100), output = list(grid = grid))
class(fit)
partition(fit)

}
\references{
Wade, S.,  Ghahramani, Z. (2018). Bayesian cluster analysis: Point estimation and credible balls.
Bayesian Analysis, 13, 559-626.
}
