% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-bysector.R
\name{BRVM_bySector}
\alias{BRVM_bySector}
\title{BRVM By Sector}
\usage{
BRVM_bySector(.sectors = NULL)
}
\arguments{
\item{.sectors}{A vector of sectors you wish to have returned.}
}
\value{
A tibble
}
\description{
This function will take in the name of sector(s) and returns data for companies belonging to that/those sector(s)
}
\details{
This function will take in a vector of sectors provided by the end
user and return a tibble.
}
\examples{
\donttest{
library(stringr)
library(rlang)
library(xml2)
library(rvest)
library(dplyr)

sectors <- c("Industry","Administration","PUblic service", "AUtr", "FINANCE",
            "distribution", 25)
BRVM_bySector(.sectors = sectors)
BRVM_bySector(.sectors = "All")
BRVM_bySector(.sectors = c("Other", "Agriculture"))
}

}
\seealso{
Other Data Retrieval: 
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_get1}()},
\code{\link{BRVM_get}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}
}
\author{
Koffi Frederic SESSIE

Oudouss Diakité Abdoul

Steven P. Sanderson II, MPH
}
\concept{Data Retrieval}
\concept{Sector}
