% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Chips}
\alias{Chips}
\title{Four measurements on a first wafer and four measurements on a second wafer
selected from 30 lots}
\format{A data frame/tibble with 30 observations on eight variables
\describe{ 
\item{wafer11}{first measurement of thickness of the oxide layer for \code{wafer1}} 
\item{wafer12}{second measurement of thickness of the oxide layer for \code{wafer1}}
\item{wafer13}{third measurement of thickness of the oxide layer for \code{wafer1}}
\item{wafer14}{fourth measurement of thickness of the oxide layer for \code{wafer1}}
\item{wafer21}{first measurement of thickness of the oxide layer for \code{wafer2}} 
\item{wafer22}{second measurement of thickness of the oxide layer for \code{wafer2}} 
\item{wafer23}{third measurement of thickness of the oxide layer for \code{wafer2}} 
\item{wafer24}{fourth measurement of thickness of the oxide layer for \code{wafer2}} 
}}
\source{
Yashchin, E. 1995. \dQuote{Likelihood Ratio Methods 
for Monitoring Parameters of a Nested Random Effect Model.} 
\emph{Journal of the American Statistical Association}, 90, 729-738.
}
\usage{
Chips
}
\description{
Data for Exercise 10.9
}
\examples{

with(data = Chips, 
     boxplot(wafer11, wafer12, wafer13, wafer14, wafer21, 
             wafer22, wafer23, wafer24, col = "pink")
)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
