% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Dowjones}
\alias{Dowjones}
\title{Closing yearend Dow Jones Industrial averages from 1896 through 2000}
\format{A data frame/tibble with 105 observations on three variables
\describe{ 
\item{year}{date} 
\item{close}{Dow Jones closing price} 
\item{change}{percent change from previous year} 
}}
\usage{
Dowjones
}
\description{
Data for Exercise 1.35
}
\examples{

plot(close ~ year, data = Dowjones, type = "l", main = "Exercise 1.35")
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Dowjones, aes(x = year, y = close)) +
           geom_point(size = 0.5) + 
           geom_line(color = "red") + 
           theme_bw() + 
           labs(y = "Dow Jones Closing Price")
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
